/*
 * Decompiled with CFR 0.152.
 */
package oracle.cluster.impl.verification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.List;
import oracle.cluster.verification.DiskInfoResultSet;
import oracle.cluster.verification.InvalidPathException;
import oracle.cluster.verification.NodeResultStatus;
import oracle.cluster.verification.NodeResultsUnavailableException;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.cluster.verification.VerificationResult;
import oracle.ops.mgmt.nls.MessageBundle;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.storage.PathDiskInfo;
import oracle.ops.verification.framework.util.VerificationUtil;

public class DiskInfoResultSetImpl
extends ResultSet
implements DiskInfoResultSet {
    private static MessageBundle s_msgBundle = VerificationUtil.getMessageBundle("Prvf");
    private Hashtable<String, PathDiskInfo> m_nodePathInfoList = null;
    private String m_origPath = null;
    private List<String> m_origNodeList = null;

    public DiskInfoResultSetImpl(String[] nodeList, String path) throws InvalidPathException {
        if (path == null || path.length() == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
        }
        if (nodeList == null || nodeList.length == 0) {
            throw new InvalidPathException(s_msgBundle.getMessage("7514", false));
        }
        this.m_origNodeList = Arrays.asList(nodeList);
        this.m_origPath = path;
        this.m_nodePathInfoList = new Hashtable();
    }

    public void addPathInfo(PathDiskInfo pathInfo) {
        if (pathInfo == null) {
            return;
        }
        String node = pathInfo.getNode();
        if (pathInfo.getStatus() == 1) {
            Trace.out((String)("Successfully retrieved information on node " + node + " adding data to resultset"));
            Trace.out((String)("Adding pathInfo for path " + pathInfo.getOrigPath() + " on node " + pathInfo.getNode() + " the resolved mount point is " + pathInfo.getName() + " with one of the shortest mountpath as " + pathInfo.getMountPathOrigin()));
        } else {
            Trace.out((String)("Failed to retrieve information on node " + node + " adding appropriate data to resultset"));
        }
        this.m_nodePathInfoList.put(node, pathInfo);
        this.addResult(node, pathInfo.getResult());
    }

    @Override
    public String getFileSystem(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        if (this.m_nodePathInfoList.containsKey(node)) {
            return this.m_nodePathInfoList.get(node).getFileSystem();
        }
        return null;
    }

    @Override
    public boolean isRAW(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        String fileSystem = this.getFileSystem(node);
        if (VerificationUtil.isStringGood(fileSystem)) {
            return fileSystem.trim().equalsIgnoreCase("RAW");
        }
        return false;
    }

    @Override
    public boolean isNTFS(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        String fileSystem = this.getFileSystem(node);
        if (VerificationUtil.isStringGood(fileSystem)) {
            return fileSystem.equalsIgnoreCase("NTFS");
        }
        return false;
    }

    @Override
    public boolean isACFS(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        String fileSystem = this.getFileSystem(node);
        if (VerificationUtil.isStringGood(fileSystem)) {
            return fileSystem.equalsIgnoreCase("ACFS");
        }
        return false;
    }

    @Override
    public boolean isOCFS(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        String fileSystem = this.getFileSystem(node);
        if (VerificationUtil.isStringGood(fileSystem)) {
            return fileSystem.toUpperCase().startsWith("OCFS") || fileSystem.equalsIgnoreCase("ORACFS");
        }
        return false;
    }

    @Override
    public String getMountPointForPath(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        if (this.m_nodePathInfoList.containsKey(node)) {
            return this.m_nodePathInfoList.get(node).getMountPathOrigin();
        }
        return null;
    }

    @Override
    public boolean checkPathForSameMountPoint(String node, DiskInfoResultSet pathResultSet) throws InvalidPathException, VerificationException {
        boolean sameLocation;
        block6: {
            this.assertResultNode(node);
            if (pathResultSet == null) {
                throw new InvalidPathException(s_msgBundle.getMessage("7517", false));
            }
            sameLocation = false;
            try {
                VerificationResult nodeResult = pathResultSet.getNodeResult(node);
                if (nodeResult.getNodeResultStatus() == NodeResultStatus.SUCCESSFUL) {
                    if (pathResultSet.getFileSystem(node).equals(this.getFileSystem(node)) && pathResultSet.getPathInfo(node).checkSameMountPoint(this.getPathInfo(node))) {
                        sameLocation = true;
                    }
                    break block6;
                }
                List<VerificationError> errors = nodeResult.getErrors();
                String errMsg = new String();
                for (VerificationError error : errors) {
                    errMsg = errMsg + (errMsg.length() == 0 ? error.getErrorMessage() : VerificationConstants.LINE_SEPARATOR + error.getErrorMessage());
                }
                throw new VerificationException(errMsg);
            }
            catch (NodeResultsUnavailableException nrue) {
                throw new VerificationException(nrue.getMessage());
            }
        }
        return sameLocation;
    }

    @Override
    public boolean checkPathForSameMountPoint(DiskInfoResultSet pathResultSet) throws InvalidPathException, VerificationException {
        boolean sameLocation = true;
        for (String node : this.m_origNodeList) {
            if (this.checkPathForSameMountPoint(node, pathResultSet)) continue;
            sameLocation = false;
        }
        return sameLocation;
    }

    private void assertNode(String node) throws VerificationException {
        if (!VerificationUtil.isStringGood(node) || !this.m_origNodeList.contains(node)) {
            throw new VerificationException(s_msgBundle.getMessage("7514", false));
        }
    }

    private void assertResultNode(String node) throws VerificationException {
        this.assertNode(node);
        try {
            VerificationResult nodeResult = this.getNodeResult(node);
            if (nodeResult.getNodeResultStatus() != NodeResultStatus.SUCCESSFUL) {
                List<VerificationError> errors = nodeResult.getErrors();
                String errMsg = new String();
                for (VerificationError error : errors) {
                    errMsg = errMsg + (errMsg.length() == 0 ? error.getErrorMessage() : VerificationConstants.LINE_SEPARATOR + error.getErrorMessage());
                }
                throw new VerificationException(errMsg);
            }
        }
        catch (NodeResultsUnavailableException nrue) {
            throw new VerificationException(nrue.getMessage());
        }
    }

    @Override
    public PathDiskInfo getPathInfo(String node) throws InvalidPathException, VerificationException {
        this.assertNode(node);
        if (this.m_nodePathInfoList.containsKey(node)) {
            return this.m_nodePathInfoList.get(node);
        }
        return null;
    }

    @Override
    public List<VerificationError> getErrors(String node) {
        List<VerificationError> errorList = null;
        errorList = this.m_nodePathInfoList.containsKey(node) ? this.m_nodePathInfoList.get(node).getErrors() : new ArrayList<VerificationError>();
        return errorList;
    }

    @Override
    public String getErrorsMessage(String node) {
        String errorMsg = "";
        List<VerificationError> errorList = this.getErrors(node);
        for (VerificationError error : errorList) {
            errorMsg = errorMsg + (errorMsg.length() == 0 ? "" : VerificationConstants.FILE_SEPARATOR + error.getErrorMessage());
        }
        return errorMsg;
    }
}

